<?php

namespace App\Modes\Document;

use Illuminate\Database\Eloquent\Model;

class Document extends Model 
{

    protected $table = 'documents';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User', 'id');
    }

    public function notes()
    {
        return $this->hasMany('Notes', 'document_id');
    }

    public function file()
    {
        return $this->hasOne('DocumentFiles', 'id');
    }

    public function task()
    {
        return $this->belongsTo('Task', 'id');
    }

    public function disorders()
    {
        return $this->belongsTo('Disorders', 'id');
    }

}